' Invader for Colecovision - cvbasic
' Started 7/5/2024
' Brian Kumanchik


' cvbasic invader.bas invader.asm
' gasm80 invader.asm -o invader.rom
' drag and drop invader.rom on to ColEm to run


' colecovision resolution 256 x 196 - 32 col x 24 row
' Z = button 1, A = button 2
' x = 255, y = 190 to hide sprite

	
	

	
	define sprite 0,8,sprites 	' sprites include at bottom of code
	
	
	gosub init_vars				' initialize variables
	
	
	' array to hold pointer for fake random invader restart x position
	dim r(5) ' uses [array_pointer] variable for index
	r(0) = 83     
	r(1) = 212     
	r(2) = 126    
	r(3) = 40    
	r(4) = 169    

	
' main loop -----------------------------------------------------------
main_loop:
	
	wait ' wait for next frame	
	
	
	
	
	' --- GAME OVER state 1 - game over ---
	if game_over = 1 then		
		print at (11*32) + 11,"GAME OVER!"
		
		' check controller 1 button 2 to start/reset game "A button"
		if cont1.button2 then
			gosub init_vars ' initialize variables	' starting turret shot y position
			'start_pressed = 1				
		end if		
	end if	
	' --- end GAME OVER state 1 - game over ---
		
		
		
	
	' --- GAME OVER state 0 - game running ---
	if game_over = 0 then
			
		
		if inv_hit = 0 then 
			gosub animate_move_inv	' animate and move invader
		end if
		
		
		' invader fire
		inv_fire_delay = inv_fire_delay - 1	
		if inv_fire_delay = 0 then
			inv_fire_delay = 120
			inv_fired = 1
			inv_shot_x = inv_x
			inv_shot_y = inv_y + 6		
		end if
				
		
		' check controller 1 left/right to move turret 
		if cont1.left and tur_x >= 10 and tur_hit = 0 then 
			tur_x = tur_x - 2
		end if	
		if cont1.right and tur_x <= 234 and tur_hit = 0 then
			tur_x = tur_x + 2
		end if
			
			
		' check controller 1 button 1 to fire turret "B button"	
		if cont1.button and fire_pressed = 0 and tur_hit = 0 and tur_fired = 0 then
			fire_pressed = 1
			tur_fired = 1			
			tur_shot_x = tur_x
			tur_shot_y = tur_y				
			'sound_tur_shot = 1			
		end if
				
		
		' stops autofire by making sure button is released after press
		if cont1.button = 0 and tur_fired = 0 then			
			fire_pressed = 0			
		end if
				
		
		' check if turret shot collides with invader
		t1 = tur_shot_x + 6		' turret shot's x (single pixel wide)
		t2 = tur_shot_y + 3		' turret shot's top edge
		is1 = inv_x				' invader's left edge
		is2 = inv_x + 10		' invader's right edge
		is3 = inv_y + 15		' invader's bottom edge			
		' do actual check using variables from above				
		if t1 > is1 and t1 < is2 and t2 < is3 then
			if inv_hit = 0 then
				inv_hit = 1
				#score = #score + 10
				'sound_inv_hit = 1				
			end if
		end if
				
		
		' check if invader shot collides with turret
		is1 = inv_shot_x + 4  	' invader shot's left edge 
		is2 = inv_shot_x + 6  	' invader shot's right edge
		is3 = inv_shot_y + 15  	' invader shot's bottom edge
		t1 = tur_x				' turret's left edge
		t2 = tur_x + 12 		' turret's right edge
		t3 = tur_y + 11			' turret's top edge
		' do actual check using variables from above			
		if is2 > t1 and is1 < t2 and is3 > t3 then
			tur_hit = 1				
		end if
		
		
		
		
		' draw stuff below here -----------------------------------------------------
		
		
		
				
		' draw turret sprites		
		if tur_hit = 0 then 
			' if turret HAS NOT been hit draw regular turret
			sprite 0,tur_y,tur_x,0,2
			' hide turret explodion frames
			sprite 1,190,255,4,2
			sprite 2,190,255,8,2
		' if turret HAS been hit play turret exploding animation
		else
			' hide turret sprite
			sprite 0,190,255,0,2
			' play turret exploding animation 3 times			
			if tur_exp_times = 0 then 				
				tur_hit = 0
				tur_exp_times = 3 	' play animation 3 times
				lives = lives - 1	' lose life				
				if lives = 0 then 	' if lives = 0...
					game_over = 1 	' ...set game state to game over								
				end if	
			end if
			
			' keeps track of turret explosion frames (1 and 2)
			tur_exp_delay = tur_exp_delay - 1
			if tur_exp_delay = 0 then 
				tur_exp_frame = tur_exp_frame + 1				
				if tur_exp_frame > 2 then
					tur_exp_times = tur_exp_times - 1
					tur_exp_frame = 1					
				end if			
				tur_exp_delay = 15
			end if
			' draw turret exploding frames
			if tur_exp_frame = 1 then
				' draw turret explodion frame 1
				sprite 1,tur_y,tur_x,4,2
				' hide turret explodion frame 2
				sprite 2,190,255,8,2
			end if	
			if tur_exp_frame = 2 then		
				' draw turret explodion frame 2
				sprite 2,tur_y,tur_x,8,2
				' hide turret explodion frame 1
				sprite 1,190,255,4,2
			end if
		end if
		
		
		' DEBUG TEXT
		'print at 100,tur_hit
		'print at 132,tur_exp_times
		'print at 164,tur_exp_frame
		
		
		' draw turret shot sprite	
		if tur_fired = 1 then 					
			SPRITE 3,tur_shot_y,tur_shot_x,12,$f					
			tur_shot_y = tur_shot_y - 4
			if tur_shot_y < 10 then ' if shot goes off bottom of screen
				tur_fired = 0
				tur_shot_x = 255
				tur_shot_y = 190
				SPRITE 3,tur_shot_y,tur_shot_x,12,$f
			end if		
		end if	
				
				
		' draw invader sprites
		if inv_hit = 0 then
			if inv_frame = 1 then
				' invader frame 1		
				sprite 4,inv_y,inv_x,16,$a
				sprite 5,190,255,20,$a
			elseif inv_frame = 2 then
				' invader frame 2	
				sprite 5,inv_y,inv_x,20,$a
				sprite 4,190,255,16,$a			
			end if
		end if
		
		' show invader blast
		if inv_hit = 1 then
			' hide both invader sprites
			sprite 4,190,255,16,$a
			sprite 5,190,255,20,$a
			' draw invader blast
			sprite 6,inv_y,inv_x,24,$a
		
			inv_blast_delay = inv_blast_delay - 1
			if inv_blast_delay = 0 then ' reset all this stuff
				inv_hit = 0
				inv_fire_delay = 120
				inv_blast_delay = 60
				inv_delay = 30			
				inv_dir = 1
				
				' hide invader blast
				sprite 6,190,255,24,$a
				
				' set (fake) random x for invader 				
				inv_x = r(array_pointer)
				array_pointer = array_pointer + 1
				if array_pointer > 4 then
					array_pointer = 0
				end if
				inv_y = 8
			end if			
		end if		
		
		
		' draw invader shot
		if inv_fired = 1 then			
			sprite 7,inv_shot_y,inv_shot_x,28,$f	
			inv_shot_y = inv_shot_y + 4
			
			if inv_shot_y >= 168 then ' if shot goes off bottom of screen
				inv_fired = 0
				inv_shot_x = 255
				inv_shot_y = 190
				' hide invader shot sprite
				sprite 7,inv_shot_y,inv_shot_x,28,$f
			end if		
		end if	
		
		
		' print score and lives
		print AT 0,"SCORE:",#score		
		print AT 25,"LIVES:",lives
	
	
	end if	
	' --- end GAME OVER state 0 - game running ---		
	
	
	goto main_loop
' end main loop -------------------------------------------------------	
	

' animate and move invader
animate_move_inv:  procedure
	inv_delay = inv_delay - 1	
	if inv_delay = 0 then
		inv_delay = 15		
					
		' if dir = 1 then move right, if hit right reverse and drop	
		if inv_dir = 1 then
			inv_x = inv_x + 2
				if inv_x >= 234 then 		
					inv_dir = 0
					inv_y = inv_y + 3					
				end if		
		' if dir = 0 then move left, if hit left reverse and drop
		elseif inv_dir = 0 then
			inv_x = inv_x - 2
				if inv_x <= 10 then 		
					inv_dir = 1
					inv_y = inv_y + 3				
				end if
		end if		
		
		' update invader frame 1,2,1,2...
		inv_frame = inv_frame + 1
		if inv_frame > 2 then 
			inv_frame = 1
		end if		
	end if

	return
	end	

	
		
	' includes - should be at end		
	include "globals.bas" 
	include "sprites.bas"

	